﻿/*  NEEDS THESE THINGS:
	_this
	walkInertia.as  (as walk_obj)
	react.as
	loopManagerMC.as  (as LOOP)
	[walkSpeed]
	[RAM.keys.run]
	[mapTileSize]
	MAP.collision_array
	"run_smoke_particle"		(linkage)
*/
allowRun = (allowRun===undefined) ? true : allowRun;									// Allow the player to sprint by holding the SHIFT key
run_obj = runFunc(function(){
	if( !RAM )	return;
	if( RAM.keys == undefined )		RAM.keys = {};
	if( RAM.keys.run == undefined )		RAM.keys.run = Key.SHIFT;
	var mapTileSize = mapTileSize || 16;
	
	var groundTerrain = [0];		// anything except walls
	#include "../walkSpeed.as"
	walkSpeed.run = {
		walkSpeed: walkSpeed.normal.walkSpeed * 1.7,
		acel: walkSpeed.normal.acel * 1.7,
		decel: walkSpeed.normal.decel / 1.7
	}
	
	// particle behavior
	var runSmokeEmitter = new ParticleSystem( _this, {
		particlesPerFrame:0,		// How many particles to create per frame.  This can also be a decimal to skip frames.
		sprayTime:null,					// How long to emit particles
		speed:1,								// How many pixels to move per frame
		speedVariation:0,				// A random variation added or subtracted from the speed.  (ie:  speed:4  variation:2  result: 2-6 )
		life:30,								// How long each particle lasts.
		lifeVariation:0,				// A random variation added or subtracted from the life.  (ie:  life:10  variation:10  result: 5-15 )
		scale:1,								// A size multiplier.  (1 = full size)
		scaleVariation:1.5,			// A random variation added or subtracted from the scale.  (ie:  scale:4  variation:2  result: 2-6 )
		growFrames:0,						// How many frames to scale up near the beginning of a particle's life
		shrinkFrames:0,					// How many frames to scale down near the end of a particle's life
		fadeInFrames:0,					// How many frames to fade-in near the beginning of a particle's life
		fadeOutFrames:8,				// How many frames to fade-out near the end of a particle's life
		customData:{
			_alpha: 50,
			noCollide: true
		},					// Arbitrary data passed to the particle itself. This allows custom effects to recieve parameters.
		image:"run_smoke_particle",	// The image used for each particle
		angle:90,								// The direction (in degrees) to spray particles in.  (0 = right, 90 = up, 180 = left, 270 = down)
		spread:140							// A random variation added or subtracted from the angle.  (ie:  angle:90  variation:2  result: 89-91 )
	} );// end emitter
	
	var run_obj = {
		wasRunning: false,
		loop:function(){
			if(!_name){
				trace("*** Emergency smoke clean-up!");
				cleanUpEmitter();
				delete run_obj.loop;
				return;
			}// if:  this sprite stops existing
			
			// don't sprint if:
			var runCancelled = false;
			if( isPaused )																							runCancelled = true;		// cancel if the player is paused
			else if( runKeyIsHeld() === false )													runCancelled = true;
			//else if( !(walk_obj.xVel != 0  ||  walk_obj.yVel != 0) )		runCancelled = true;
			else if( walk_obj.xVel === 0  &&  walk_obj.yVel === 0 )			runCancelled = true;
			else if( isOnValidTerrain() === false )											runCancelled = true;
			else if( !allowRun )																				runCancelled = true;
			
			// stop sprinting
			if( run_obj.wasRunning == true  &&  runCancelled ){
				run_obj.wasRunning = false;
				if( walkSpeed.value == "run" )		walkSpeed.change( "normal" );
				runSmokeEmitter.particlesPerFrame = 0;
			}// if: running has been disabled
			if( runCancelled )		return;
			
			// start sprinting
			if( run_obj.wasRunning == false ){
				run_obj.wasRunning = true;
				walkSpeed.change( "run" );
				runSmokeEmitter.particlesPerFrame = 0.5;
			}// if:  was not running
		}// loop()
	}// run_obj
	
	function runKeyIsHeld(){
		return Key.isDown( RAM.keys.run );
	}// runKeyIsHeld()
	
	function isOnValidTerrain(){
		// sprinting depends on the ground terrain
		var tileX = Math.floor(_x/mapTileSize);
		var tileY = Math.floor(_y/mapTileSize);
		var checkTerrain = MAP.collision_array[tileX][tileY];
		var output = false;
		for(var t=0; t<groundTerrain.length; t++){
			if(groundTerrain[t] === checkTerrain){
				output = true;
				break;
			}// if:  checkTerrain is one of the valid options, then pass
		}// for:  each groundTerrain
		return output;
	}// isOnValidTerrain()
	
	
	// startup
	LOOP.addObject( null, "fx" );		// ensure that "fx" loop-set exists
	//LOOP.addObject( run_obj, "fx" );
	// particles animate manually instead of automatically
	clearInterval( runSmokeEmitter.loopInterval );
	
	// enable sprint smoke-particles		(comment this out to disable smoke-particles)
	//LOOP.addObject( runSmokeEmitter, "fx" );
	react.to("onEnterFrame").then = function(){
		if( LOOP.isPaused("fx") )		return;		// abort if:  "fx" is paused
		run_obj.loop();
		//runSmokeEmitter.loop();
	}// player's onEnterFrame()
	
	// clean-up
	react.to("unload").then = cleanUpEmitter;
	
	function cleanUpEmitter(){
		runSmokeEmitter.deleteAllParticles();
		LOOP.removeObject( runSmokeEmitter, "fx" );
		LOOP.removeObject( run_obj, "fx" );
		delete runSmokeEmitter;
	}// cleanUpEmitter()
	
	//return run_obj; 	 // nothing needs to directly interact with this object  (yet)
});// run_obj